#ifndef CE2_HASH_HMAC_ERROR_H
#define CE2_HASH_HMAC_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "CE2_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Fri Mar 02 13:38:07 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains contains error codes for HASH and HMAC functions.
* 
* \version CE2_HASH_HMAC_Error.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/

/* HASH */
/* CE2_HASH() error codes */
#define CE2_HASH_ILLEGAL_HASH_OP_MODE_ERROR (CE2_HASH_MODULE_ERROR_BASE + 1)
#define CE2_HASH_INVALID_DATA_IN_PTR_ERROR  (CE2_HASH_MODULE_ERROR_BASE + 2)

/* HMAC */
/* HMAC module on the LLF layer base address - 0x00F10300 */
#define LLF_HMAC_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * HMAC_ERROR_IDX ) )   

/* CE2_HMAC() error codes */
#define CE2_HMAC_ILLEGAL_HASH_OP_MODE_ERROR (CE2_HMAC_MODULE_ERROR_BASE + 1)
#define CE2_HMAC_INVALID_KEY_PTR_ERROR		(CE2_HMAC_MODULE_ERROR_BASE + 2)
#define CE2_HMAC_INVALID_DATA_IN_PTR_ERROR  (CE2_HMAC_MODULE_ERROR_BASE + 3)

#ifdef __cplusplus
}
#endif

#endif /* CE2_HASH_HMAC_ERROR_H */
